/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.IElementEntriesFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class PHPModuleBasedEntriesFilter
implements IElementEntriesFilter {
    private Set<IModule> allowedModules = new HashSet<IModule>();

    public PHPModuleBasedEntriesFilter() {
    }

    public PHPModuleBasedEntriesFilter(Collection<IModule> toAdd) {
        this.allowedModules.addAll(toAdd);
    }

    public void addAllowedModule(IModule module) {
        this.allowedModules.add(module);
    }

    public void addAllowedModules(Collection<IModule> modules) {
        this.allowedModules.addAll(modules);
    }

    @Override
    public Set<IElementEntry> filter(Collection<IElementEntry> toFilter) {
        if (toFilter == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : toFilter) {
            if (entry.getModule() == null || !this.allowedModules.contains(entry.getModule())) continue;
            result.add(entry);
        }
        return result;
    }
}

